// AnalogDeviceVideoGraph.cpp: implementation of the CAnalogDeviceVideoGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AnalogDeviceVideoGraph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

VOID CAnalogDeviceVideoGraph::SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC310] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", this );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 1 + 10, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnalogDeviceVideoGraph::CAnalogDeviceVideoGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoGraph::CAnalogDeviceVideoGraph()" );

	for( ULONG i = 0 ; i < 32 ; i++ ) {

		m_pCaptureSourceBaseFilters[ i ] = NULL;
		
		m_pAMAnalogVideoDecoders[ i ] = NULL;

		m_pAMStreamConfigs[ i ] = NULL;

		m_pSampleGrabberBaseFilters[ i ] = NULL;

		m_pSampleGrabbers[ i ] = NULL;

		m_oSampleGrabbers[ i ].SetCallback( NULL, NULL );
	}
}

CAnalogDeviceVideoGraph::~CAnalogDeviceVideoGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoGraph::~CAnalogDeviceVideoGraph()" );

	CAnalogDeviceVideoGraph::Close( FALSE );
}

BOOL CAnalogDeviceVideoGraph::Close( BOOL bDumpDebugMessage )
{
	if( bDumpDebugMessage ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Close()" ); }

	if( m_pCommonMediaControl ) { if( GetState() == State_Running ) { Stop(); } }

	if( m_pCommonMediaControl ) { if( GetState() == State_Paused ) { Stop(); } }

	for( ULONG i = 0 ; i < 32 ; i++ ) {

		RELEASE( m_pCaptureSourceBaseFilters[ i ] );

		RELEASE( m_pAMAnalogVideoDecoders[ i ] );

		RELEASE( m_pAMStreamConfigs[ i ] );

		RELEASE( m_pSampleGrabbers[ i ] );

		RELEASE( m_pSampleGrabberBaseFilters[ i ] );

		m_oSampleGrabbers[ i ].SetCallback( NULL, NULL );
	}
	return CloseGraphBuilder( bDumpDebugMessage );
}

BOOL CAnalogDeviceVideoGraph::Create( PWSTR              pwszDevName, 
									 
									  PF_BUFFER_CALLBACK pBufferCBs[ 32 ], 

									  PVOID              pUserDatas[ 32 ] )
{
	WCHAR pwszFilterNameBuffer[ 256 ];

	// CREATE GRAPH BUILDER RESOURCE
	//
	if( FALSE == CreateGraphBuilder() ) { return FALSE; }

	for( ULONG i = 0 ; i < 32 ; i++ ) {

		// FIND/ADD CAPTURE SOURCE FILTER INTO GRAPH
		//
		StringCchPrintfW( pwszFilterNameBuffer, 256, L"%ws, Analog Capture (#%02d)", pwszDevName, i + 1 );

		if( FALSE == FindFilter( &CLSID_VideoInputDeviceCategory, pwszFilterNameBuffer, 0, &m_pCaptureSourceBaseFilters[ i ], pwszFilterNameBuffer, 256 ) ) { 
			
			return FALSE; 
		}
		if( FALSE == AddFilter( m_pCaptureSourceBaseFilters[ i ], pwszFilterNameBuffer ) ) { 
			
			return FALSE; 
		}
		if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( NULL, NULL, m_pCaptureSourceBaseFilters[ i ], IID_IAMAnalogVideoDecoder, (VOID **)(&m_pAMAnalogVideoDecoders[ i ]) )) ) { 
			
			SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_IAMAnalogVideoDecoder) )" );

			if( FAILED(m_pAMAnalogVideoDecoders[ i ]->put_TVFormat( 0x00000010 )) ) { // STANDARD = PAL.B
				
				SC_DEBUG( "CAnalogDeviceVideoGraph::SetStandard( IAMAnalogVideoDecoder::put_TVFormat() ) ERROR!!" ); 
				
				return FALSE; 
			}
		}
		if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( &LOOK_DOWNSTREAM_ONLY, NULL, m_pCaptureSourceBaseFilters[ i ], IID_IAMStreamConfig, (VOID **)(&m_pAMStreamConfigs[ i ]) )) ) {
	
			GUID guid = { 0x00000000, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 };

			AM_MEDIA_TYPE * pmt = NULL;

			SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_IAMStreamConfig) )" );

			if( FAILED(m_pAMStreamConfigs[ i ]->GetFormat( &pmt )) ) {
				
				SC_DEBUG( "CAnalogDeviceVideoGraph::Create( IAMStreamConfig::GetFormat() ) ERROR!!" );
				
				return FALSE;
			}
			((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biCompression = guid.Data1 = MAKEFOURCC('Y', 'U', 'Y', '2');

			((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biHeight = 576;

			((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biWidth = 720;

			((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biBitCount = 16;

			((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biSizeImage = 720 * 576 * 16 / 8;

			((VIDEOINFOHEADER *)(pmt->pbFormat))->AvgTimePerFrame = (ULONG)(INT)(10000000.0 / 25.000);

			((VIDEOINFOHEADER *)(pmt->pbFormat))->dwBitRate = (ULONG)(INT)(720 * 576 * 16 * 25.000 * 8);

			pmt->subtype = guid;

			if( FAILED(m_pAMStreamConfigs[ i ]->SetFormat( pmt )) ) { // YUY2, 720 X 576, 25.000
			
				SC_DEBUG( "CAnalogDeviceVideoGraph::Create( IAMStreamConfig::SetFormat() ) ERROR!!" ); 
			
				if( pmt ) {

					DeleteMediaType( pmt );

					pmt = NULL;
				}
				return FALSE;
			}
			if( pmt ) {

				DeleteMediaType( pmt );

				pmt = NULL;
			}
		}

		// ADD SAMPLE GRABBER FILTER INTO GRAPH
		//
		StringCchPrintfW( pwszFilterNameBuffer, 256, L"Sample Grabber (#%02d)", i + 1 );

		if( FAILED(CoCreateInstance( CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (VOID **)(&m_pSampleGrabberBaseFilters[ i ]) )) ) {
			
			SC_DEBUG( "CAnalogDeviceVideoGraph::Create( CoCreateInstance(CLSID_SampleGrabber) ) ERROR!!" ); 
		
			return FALSE; 
		}
		if( FALSE == AddFilter( m_pSampleGrabberBaseFilters[ i ], pwszFilterNameBuffer ) ) { 
			
			return FALSE;
		}
		if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( NULL, NULL, m_pSampleGrabberBaseFilters[ i ], IID_ISampleGrabber, (VOID **)(&m_pSampleGrabbers[ i ]) )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoGraph::Create( FindInterface(IID_ISampleGrabber) )" );

			if( NULL != m_pSampleGrabbers[ i ] ) {

				if( FAILED(m_pSampleGrabbers[ i ]->SetOneShot( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetOneShot() ) ERROR!!" ); return FALSE; }

				if( FAILED(m_pSampleGrabbers[ i ]->SetBufferSamples( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetBufferSamples() ) ERROR!!" ); return FALSE; }

				if( FAILED(m_pSampleGrabbers[ i ]->SetCallback( &m_oSampleGrabbers[ i ], 0 )) ) { SC_DEBUG( "CAnalogDeviceVideoGraph::Create( ISampleGrabber::SetCallback() ) ERROR!!" ); return FALSE; }

				m_oSampleGrabbers[ i ].SetCallback( pBufferCBs[ i ], pUserDatas[ i ] );
			}
		}

		// CONNECT THEM
		//
		if( FALSE == ConnectFilters( m_pCaptureSourceBaseFilters[ i ], m_pSampleGrabberBaseFilters[ i ] ) ) { 
			
			return FALSE; 
		}
	}

	// COMPLETE
	//
	SC_DEBUG( "CAnalogDeviceVideoGraph::Create()" );

	return TRUE;
}


