// MultiRecoderDemoDlg.h : header file
//

#if !defined(AFX_MULTIRECODERDEMODLG_H__51CD9371_CF2F_41CC_A73F_E30B79E79FD7__INCLUDED_)
#define AFX_MULTIRECODERDEMODLG_H__51CD9371_CF2F_41CC_A73F_E30B79E79FD7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma once
#include "ChannelWindow.h"

#define MAX_ALLSECTIONS		2048  
#define MAX_SECTION			260  
#define MAX_ALLKEYS			6000  
#define MAX_KEY				260
#define MAX_VALUE			255 

typedef enum tagINI_RESOULT {
	INI_RS_SUCCESSFUL				= 0x00,
	INI_RS_ERROR_GENERAL			= 0x01,
	INI_RS_ERROR_FILE_EXIST			= 0x02,
	INI_RS_ERROR_FILE_NOT_EXIST		= 0x03
};


typedef struct tagLiveData {

	//CHAR szSection[ 4 ][ MAX_SECTION ];
	//CHAR szSection[4][4] = {{ "set", "set", "set", "set" }};
	//memset( szSection[0], 0, sizeof( szSection[0] ) );

	/*
	tagLiveData( BYTE nNumber ) {

		nId = nNumber;

		memset( this, 0, sizeof( tagLiveData ) );

		dwSize = sizeof( tagLiveData );	
		
		//memset( szSection, 0, sizeof( szSection ) );
		wsprintf( szSecRecord, "RecordPanel%2d", nNumber );
		wsprintf( szKeyRecordPath, "RecordPath" );
		wsprintf( szValueRecordPath, "%s", m_strRecordPath[ nNumber ] );
	}
	*/
	/*
	tagLiveData() {

		nId = nNumber;

		memset( this, 0, sizeof( tagLiveData ) );

		dwSize = sizeof( tagLiveData );	
		
		//memset( szSection, 0, sizeof( szSection ) );
		wsprintf( szSecRecord, "RecordPanel%2d", nNumber );
		wsprintf( szKeyRecordPath, "RecordPath" );
		wsprintf( szValueRecordPath, "%s", m_strRecordPath[ nNumber ] );
	}*/



	DWORD dwSize;

	BYTE nId;

	
	CHAR szSecRecord[ MAX_SECTION ];

	// RECORD PATH
	CHAR szKeyRecordPath[ MAX_KEY ];
	CHAR szValueRecordPath[ MAX_KEY ];

	// RECORD FILE FORMAT
	//CHAR szSecFileFormat[ MAX_SECTION ];
	CHAR szKeyFileFormat[ MAX_KEY ];
	INT  nValueFileFormat;

	// RECORD STANDARD
	CHAR szKeyFileStandard[ MAX_KEY ];
	INT  nValueFileStandard;



			
} SLiveData, pSLiveData;

/*
typedef struct tagOSD_DATA {
	
	BYTE byteTextXOffset;

	BYTE byteTextYOffset;


		


} OSD_DATA, *POSD_DATA



*/

/////////////////////////////////////////////////////////////////////////////
// CMultiRecoderDemoDlg dialog

class CMultiRecoderDemoDlg : public CDialog
{
// Construction
public:
	CMultiRecoderDemoDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CMultiRecoderDemoDlg)
	enum { IDD = IDD_MULTIRECODERDEMO_DIALOG };
	CButton	m_btnStreamming;
	CEdit	m_editLiveInfo04;
	CEdit	m_editLiveInfo03;
	CEdit	m_editLiveInfo02;
	CEdit	m_editLiveInfo01;
	CEdit	m_editShareRecordInfo;
	CButton	m_btnShareRecord;
	CButton	m_btnProperty_4;
	CButton	m_btnRecord_4;
	CButton	m_btnRecord_3;
	CButton	m_btnRecord_2;
	CButton	m_btnRecord_1;
	CButton	m_btnProperty_3;
	CButton	m_btnProperty_2;
	CButton	m_btnProperty_1;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMultiRecoderDemoDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CMultiRecoderDemoDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnBtnRecord_Ch1_1();
	afx_msg void OnBtnRecord_Ch2_1();
	afx_msg void OnBtnRecord_Ch3_1();
	afx_msg void OnBtnRecord_Ch4_1();
	afx_msg void OnDestroy();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnButtonShareRecord();
	afx_msg void OnBtnLiveProperty1();
	afx_msg void OnBtnLiveProperty2();
	afx_msg void OnBtnLiveProperty3();
	afx_msg void OnBtnLiveProperty4();
	afx_msg void OnBtnSnapshot1();
	afx_msg void OnBtnSnapshot2();
	afx_msg void OnBtnSnapshot3();
	afx_msg void OnBtnSnapshot4();
	afx_msg void OnButtonShareProperty();
	afx_msg void OnCheckShareDiasplay();
	afx_msg void OnButtonShareStreamming();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	// FUNCTION 
	//
	BOOL				HwUninitialize();

	BOOL				HwInitialize();

	BOOL				OnLButtonDblClk_ChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point );

	BOOL				SetShareFormatChangedOutput_CShareRecord();

	CString				GetAppPath();

	BOOL				IsReceiveSignal();

public:

	// INI FILE FUNCTION 
	//
	CString				m_strIniDes;

	SLiveData			m_sLiveData[ 4 ];

	BYTE				SetIniFile( LPCTSTR lpc );					// CREATE INI FILE

	BOOL				SetProfileData( CString strFileName );

	BOOL				GetProfileData( CString strFileName );

	
public:

	// STATIC CLASS VARIABLE
	//
	static CMultiRecoderDemoDlg*	s_pCMultiRecoderDemoDlg;

	static CRect					s_rect_live_window_pos[ 4 ];

	static CRect					s_rect_clone_window_pos[ 4 ];

	static CRect					s_rect_share_window_pos;

public:

	// MANAGED THE WINDOWS
	//
	CChannelWindow		m_oChannelWindows_LIVE[ 4 ];

	CChannelWindow		m_oChannelWindows_BK[ 4 ];

	//CChannelWindow		m_oCloneWindows[ 4 ];

	//CChannelWindow		m_oCloneOSDWindows[ 4 ];

	CChannelWindow		m_oShareWindows;

	CChannelWindow		m_oShareWindows_BK;

public:

	// ABOUT DEVICE RESOURCE
	// 
	PVOID				m_hVideoDevice[ 4 ];

	PVOID				m_hCloneCapDev[ 4 ];

	PVOID				m_hCloneOSDCapDev[ 4 ];

	ULONG				m_nVideoWidth[ 4 ];

	ULONG				m_nVideoHeight[ 4 ];

	BOOL				m_bVideoIsInterleaved[ 4 ];

	ULONG				m_nVideoFrameRate[ 4 ];
	
	BOOL				m_bNoSignal[ 4 ];

	//BOOL				m_bVideoDeinterlaceEnable;

	CString				m_strVideoInput;

	CString				m_strAudioInput;

public:

	CString				m_strFormatChangedOutput[ 4 ];

public:

	// RECORDING PARAM 
	//
	CString				m_strDefaultPath[ 4 ];

	CString				m_strRecordPath[ 4 ];

	//CString				m_strRecordFileName[ 4 ];

	ULONG				m_nRecordFormat[ 4 ];			// 0x00000000 is avi / 0x00000001 is mp4

	ULONG				m_nRecordStandard[ 4 ];			// 0x00000000 is NTSC / 0x00000001 is PAL

	ULONG				m_nRecordResolutionPos[ 4 ];

	ULONG				m_nRecordFrameRatePos[ 4 ];

	ULONG				m_nRecordAudioFormat[ 4 ];		// 0x00000000 is PCM / 0x00000001 is AAC

	ULONG				m_nRecordGOP[ 4 ];

	ULONG				m_nRecordMode[ 4 ];

	ULONG				m_nRecordBiteRate[ 4 ];

	ULONG				m_nRecordQuality[ 4 ];

	ULONG				m_nRecordScale[ 4 ];

	BOOL				m_bRecordSupportGPU[ 4 ];

	BOOL				m_bRecordAutoDeinterlace[ 4 ];

public:

	//	SNAPSHOT SETTING PARAM
	//
	ULONG				m_nSnapshotType[ 4 ];	

	ULONG				m_nSnapshotSyncDuration[ 4 ];

	ULONG				m_nContinueSnapshotNum[ 4 ];

	CString				m_strSnapshotPath[ 4 ];

public:

	// LIVE PROPERTY
	//
	ULONG				m_nLiveTabPage[ 4 ];

	ULONG				m_nLivePropertyNumber;

public:

	// AUDIO PROPERTIES
	//
	ULONG				m_nAudioInput[ 4 ];

	ULONG				m_nAudioVolume[ 4 ];

	ULONG				m_nAudioChannels[ 4 ];

	ULONG				m_nAudioBitsPerSample[ 4 ];

	ULONG				m_nAudioSampleFrequency[ 4 ];

	ULONG				m_nCurSelectChannelNumber;

	ULONG				m_nAudioPlayChannel;

public:

	// ABOUT RECORD FILE PARAMS
	//
	BOOL				m_bShareSupportGPU1_1;

	BOOL				m_bSupportGPU1_1;
	
	BOOL				m_bIsRecord1_1;

	BOOL				m_bSupportGPU1_2;
	
	BOOL				m_bIsRecord1_2;
	
	BOOL				m_bSupportGPU2_1;
	
	BOOL				m_bIsRecord2_1;

	BOOL				m_bSupportGPU2_2;
	
	BOOL				m_bIsRecord2_2;

	BOOL				m_bSupportGPU3_1;
	
	BOOL				m_bIsRecord3_1;

	BOOL				m_bSupportGPU3_2;
	
	BOOL				m_bIsRecord3_2;

	BOOL				m_bSupportGPU4_1;
	
	BOOL				m_bIsRecord4_1;

	BOOL				m_bSupportGPU4_2;
	
	BOOL				m_bIsRecord4_2;

	BOOL				m_nWndState;

public:

	// VIDEO INPUT PROPERTY
	//
	ULONG				m_nSharpness[ 4 ];

	ULONG				m_nSaturation[ 4 ];

	ULONG				m_nHue[ 4 ];

	ULONG				m_nConstrast[ 4 ];

	ULONG				m_nBrightness[ 4 ];

public:

	// SHARE RECORDING PARAM 
	//
	BOOL				m_bIsShareRecord;

	BOOL				m_bShareRecordCH[ 4 ];

	CString				m_strShareFormatChangedOutput;


	CString				m_strShareRecordPath;

	CString				m_strShareRecordFileName;

	ULONG				m_nShareRecordFormat;			// 0x00000000 is avi / 0x00000001 is mp4

	ULONG				m_nShareRecordStandard;			// 0x00000000 is NTSC / 0x00000001 is PAL

	ULONG				m_nShareRecordResolutionPos;

	ULONG				m_nShareRecordFrameRatePos;

	ULONG				m_nShareRecordAudioFormat;		// 0x00000000 is PCM / 0x00000001 is AAC

	ULONG				m_nShareRecordGOP;

	ULONG				m_nShareRecordMode;

	ULONG				m_nShareRecordBiteRate;

	ULONG				m_nShareRecordQuality;

	ULONG				m_nShareRecordScale;

	BOOL				m_bShareRecordSupportGPU;

	BOOL				m_bShareRecordAutoDeinterlace;

	ULONG				m_nShareDisplayChannelNumber;

	BOOL				m_bIsShareDisplay;

	BOOL				m_bIsSetShareDisplayBuffer;				// 2013.01.04 @ FIXED A BUG WHERE LIVE CHANNEL WOULD APPEAR INCORRECTLY WHILE SHARE RECORD START

	BOOL				m_bIsSetShareRecordBuffer;					// 2013.01.04 @ FIXED A BUG WHERE LIVE CHANNEL WOULD APPEAR INCORRECTLY WHILE SHARE RECORD START
	
public:

	// SHARE STREAMMING PARAM 
	//
	PVOID				m_hStreamServer;

	BOOL				m_bIsSetShareStreammingBuffer;

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MULTIRECODERDEMODLG_H__51CD9371_CF2F_41CC_A73F_E30B79E79FD7__INCLUDED_)
